<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements MustVerifyEmail
{
  use HasApiTokens, HasFactory, Notifiable;

  /**
   * The attributes that are mass assignable.
   *
   * @var array<int, string>
   */
  protected $fillable = [
    'email',
    'password',
    'referral',
    'sub_of',
    'sub_count',
    'sub_index',
    'subs',
    'is_banned',
  ];

  /**
   * The attributes that should be hidden for serialization.
   *
   * @var array<int, string>
   */
  protected $hidden = [
    'password',
    'remember_token',
  ];

  /**
   * Get the attributes that should be cast.
   *
   * @return array<string, string>
   */
  protected function casts(): array
  {
    return [
      'email_verified_at' => 'datetime',
      'password' => 'hashed',
    ];
  }

  public function Ticket()
  {
    return $this->hasMany(Ticket::class);
  }
}


/*

hi i have a laravel project via this user model:
    user : {'email',
    'password',
    'referral',
    'sub_of',
    'sub_count',
    'sub_index',
    'subs',
    'is_banned',}

when user want to sign up i want to do this senario :
it recieves this fields: 1) email 2) sub_of 3) password
step 1) cheks email be unique 
2) cheks sub_of code: its a unique code of each users referral, it has to cheks this sub_of codes is belongs to a user and this users 'sub_count' fields is less than 12;
3) then it create a new user via this email,password, sub_of

i have some another steps too, can u give me code of this steps , then i siad other steps
*/