<?php

namespace App\Http\Controllers;

use App\Models\Task;
use Illuminate\Http\Request;

class TaskController extends Controller
{
  /**
   * Display a listing of the resource.
   */
  public function index(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $result = Task::all();
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $result,
        ],
        200
      );
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }

  /**
   * Show the form for creating a new resource.
   */
  public function create()
  {
    //
  }

  /**
   * Store a newly created resource in storage.
   */
  public function store(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $request->validate(
        [
          'title' => ['required', 'unique:tasks,title'],
          'users' => ['required', 'nullable'],
        ]
      );
      $title = $request->input('title');
      $users = $request->input('users');
      //1 check the parent
      $newTask = Task::create([
        'title' => $title,
        'users' => $users,
      ]);
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $newTask,
        ],
        200
      );
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }

  /**
   * Display the specified resource.
   */
  public function show(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $request->validate(
        [
          'id' => ['required',],
        ]
      );
      $id = $request->input('id');
      //1 check the parent
      $newTask = Task::findOrFail([
        $id
      ]);
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $newTask,
        ],
        200
      );
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }

  /**
   * Show the form for editing the specified resource.
   */
  public function edit(Task $task)
  {
    //
  }

  /**
   * Update the specified resource in storage.
   */
  public function update(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $request->validate(
        [
          'title' => ['required', 'unique:tasks,title'],
          'users' => ['required', 'nullable'],
          'id' => ['required',],
        ]
      );
      $title = $request->input('title');
      $users = $request->input('users');
      $id = $request->input('id');
      //1 check the parent
      $newTask = Task::whereId($id)->update([
        'title' => $title,
        'users' => $users,
      ]);
      return response()->json(
        [
          "error" => false,
          "message" => "Successful.",
          "data" => $newTask,
        ],
        200
      );
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }

  /**
   * Remove the specified resource from storage.
   */
  public function destroy(Request $request)
  {
    if ($request->user()->tokenCan('admin')) {
      $request->validate(
        [
          'id' => ['required',],
        ]
      );
      $id = $request->input('id');
      //1 check the parent
      $task = Task::find($id);

      if ($task) {
        $task->delete();
        return response()->json(['message' => 'Task deleted successfully.'], 200);
      } else {
        return response()->json(['message' => 'Task not found.'], 404);
      }
    } else {
      return response()->json(
        [
          "error" => true,
          "message" => "unauthenticated."
        ],
        400
      );
    }
  }
}
